#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Pearls of MagmaMod01.fsh   by  fizzer  
//https://www.shadertoy.com/view/lsS3zy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float time;

float de(vec3 p)
{
	float inner_sphere_scale = 0.7;
	float s=4.0;
	float t=fract(time/0.6);
	float scale=pow(inner_sphere_scale, -t);
	float d=1e4;
	
	for(int i = 0; i < 5; i += 1)
	{
		vec3 z=p/scale,az=abs(z),w=z;
		
		if(az.x>az.y && az.x>az.z)
			w/=w.x*sign(w.x);
		else if(az.y>az.x && az.y>az.z)
			w/=w.y*sign(w.y);
			else
				w/=w.z*sign(w.z);
			
			w=normalize(floor(w*s+vec3(0.5)))*0.4;
		
		d=min(d,(distance(z,w) - 0.02*min(1.0, (float(i) + 1.0 - t) / 1.5))*scale);
		scale*=inner_sphere_scale;
	}
	
	return d;
}

mat3 rotateXMat(float a)
{
	return mat3(1.0, 0.0, 0.0, 0.0, cos(a), -sin(a), 0.0, sin(a), cos(a));
}

mat3 rotateYMat(float a)
{
	return mat3(cos(a), 0.0, -sin(a), 0.0, 1.0, 0.0, sin(a), 0.0, cos(a));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
	time=iTime+10.63;
	
	mat3 m=rotateXMat(time*0.5)*rotateYMat(time*0.7);
	
	vec2 p=fragCoord.xy/iResolution.xy*2.0-vec2(1.0);
	p.x*=iResolution.x/iResolution.y;
	vec3 ro=m*vec3(0.0,0.0,0.4);
	vec3 rd=m*normalize(vec3(p, -2.0));
	
	float t=0.0;
	
	for(int i=0;i<120;i+=1)
	{
		float d=de(ro+rd*t);
		if(abs(d)<1e-4)
			break;
		t+=d;
	}
	
	vec3 rp=ro+rd*t;
	
	vec3 col=mix(vec3(1.0,1.0,0.5),vec3(1.0,0.5,0.25)*0.1,pow(abs(rd.y),0.5));
	
	if(t<20.0)
	{
		float e=1e-3, c=de(rp);
		vec3 n=normalize(vec3(de(rp+vec3(e,0.0,0.0))-c,de(rp+vec3(0.0,e,0.0))-c,de(rp+vec3(0.0,0.0,e))-c));
		
		col=mix(vec3(0.0),vec3(1.7,0.6,0.2)*5.0*mix(0.6,1.0,(0.5+0.5*cos(time*30.0))),
				pow(0.5+0.5*cos(rp.x*50.0+sin(rp.y*10.0)*3.0+cos(rp.z*4.0)),3.0));
		
		col*=vec3(mix(0.3,2.0,0.5+0.5*dot(n,rd)));
		
		col+=vec3(pow(clamp(0.5+0.5*dot(n,rd),0.0,1.0),2.0))*0.6;
		
		vec3 l=normalize(vec3(1.0,1.0,-1.0)-rp);
		vec3 h=normalize(normalize(l)+normalize(-rd));
		
		col+=vec3(pow(clamp(0.5+0.5*dot(h,n),0.0,1.0),80.0))*0.7;
	}
	
	col+=(0.03+cos(time*7.0)*0.01)*mix(vec3(0.1,0.5,0.0)*0.3,vec3(1.2,0.7,0.1),0.5+0.5*cos(p.y*0.3+sin(p.x*0.1+time)*6.0)*sin(p.y));
	
	fragColor.rgb=sqrt(col);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

